const path = require('path');


function getDirectionByBlockAndDepth(blockName, depth) {
    // Load the object-category.json file
    const jsonFilePath = '[JSON_FILE_PLACEHOLDER]';
    const objectCategory = loadJSON(jsonFilePath);

    // Define the most concentrated depth ranges for underground blocks
    const mostConcentratedDepths = {
        cobblestone: 32,
        dirt: 64,
        gravel: 64,
        coal_ore: 32,
        iron_ore: 96,
        copper_ore: 48,
        gold_ore: -40,
        redstone_ore: -48,
        lapis_ore: -16,
        diamond_ore: -58,
        emerald_ore: 256  // specific to mountain biomes
    };

    // Average depth for common underground stones when block is not in the list
    const averageDepth = 32;

    // Check if blockName is in undergroundBlocks
    if (objectCategory.undergroundBlocks.includes(blockName)) {
        // Check if the blockName is in the mostConcentratedDepths
        if (blockName in mostConcentratedDepths) {
            const mostConcentratedDepth = mostConcentratedDepths[blockName];
            if (Math.abs(mostConcentratedDepth - depth) <= 10) {
                return new Vec3(1, 0, 1);
            } else if (depth > mostConcentratedDepth) {
                return new Vec3(0, -1, 0);
            } else {
                return new Vec3(0, 1, 0);
            }
        } else {
            // If blockName is not in mostConcentratedDepths, use the average depth
            if (Math.abs(averageDepth - depth) <= 10) {
                return new Vec3(1, 0, 1);
            } else if (depth > averageDepth) {
                return new Vec3(0, -1, 0);
            } else {
                return new Vec3(0, 1, 0);
            }
        }
    } else {
        return new Vec3(1, 0, 1);
    }
}